unit mFibonacciReal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfrmMain = class(TForm)
    edN: TEdit;
    Label1: TLabel;
    edFib: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    btIterativ: TButton;
    btRekursiv: TButton;

    procedure btIterativClick(Sender: TObject);
    procedure btRekursivClick(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  frmMain: TfrmMain;

implementation{$R *.dfm}

function FibIterativ (n:real):real;
var i, f0, f1, f2 : real;
begin
  if (n=0) or (n=1)
  then Result := n
  else begin
    f0:=0; f1:=1; f2:=f0+f1;
    i := 2;
    while i <= n do begin
      f0 := f1; f1 := f2; f2 := f0+ f1;
      i := i+1;
    end;
    Result := f1;
  end;
end;

function FibRekursiv (n:real):real;
begin
  if (n=0) or (n=1)
  then Result := n
  else Result := FibRekursiv(n-1)+FibRekursiv(n-2);
end;

procedure TfrmMain.btIterativClick(Sender: TObject);
begin
  edFib.text := floatToStr(FibIterativ(StrTofloat(edN.Text)));
end;

procedure TfrmMain.btRekursivClick(Sender: TObject);
begin
  edFib.text := floatToStr(FibRekursiv(StrTofloat(edN.Text)));
end;

end.
